# 通知設計書 10-Downloaded file is missing.

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるダウンロードファイル不在エラー通知「Downloaded file is missing.」の設計仕様を定義する。この通知は、ToolUpdate機能でダウンロードが成功したにもかかわらず、ダウンロードされたファイルが見つからない場合に表示されるエラー通知である。

### 本通知の処理概要

「Downloaded file is missing.」通知は、ダウンロード処理は正常完了したが、期待されるファイルがディスク上に存在しない異常事態を検出した際のエラー通知メカニズムである。

**業務上の目的・背景**：ダウンロードフォームがDialogResult.OKを返した（ダウンロード完了を示唆する）にもかかわらず、実際にはファイルが存在しないという矛盾した状態を検出し、ユーザーに報告する。これはディスク容量不足、アンチウイルスソフトによる削除、ファイルシステムエラーなどの予期しない問題を示唆する重要なエラーである。

**通知の送信タイミング**：DownloadFormのShowDialog()がDialogResult.OKを返したが、DownloadFile.FileExistsがFalseの場合に表示される。

**通知の受信者**：ツールの更新を実行しているユーザー。

**通知内容の概要**：「Downloaded file is missing.」というエラーメッセージがMsgError形式で表示される。Errorアイコン（赤い×マーク）、OKボタン、コピーボタンが配置される。

**期待されるアクション**：ユーザーはエラーを確認し、ディスク容量、アンチウイルスソフトの設定、ファイルシステムの状態を確認する。その後、再度ダウンロードを試みるか、手動でツールをダウンロード・配置する。

## 通知種別

アプリ内通知（タスクダイアログ/MsgError）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

ToolUpdate.Download()メソッド内でファイル存在チェックに失敗した場合に表示される。

## 通知テンプレート

### メール通知の場合

該当なし（アプリ内通知のため）

### 本文テンプレート

```
[タイトル]
Downloaded file is missing.

[コンテンツ]
（なし）

[アイコン]
Error（赤い×アイコン）

[ボタン]
OK

[リンクボタン]
Copy Message（クリックでメッセージをクリップボードにコピー）
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 固定メッセージのため変数なし | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | DownloadForm.ShowDialog() | DialogResult = OK かつ Not DownloadFile.FileExists | ダウンロード成功と判定されたがファイルが存在しない |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| DialogResult <> OK | ダウンロードがキャンセル/失敗の場合は別のメッセージを表示 |
| DownloadFile.FileExists = True | ファイルが正常に存在する場合は表示しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ToolUpdate.Download開始] --> B[DownloadForm表示]
    B --> C[ダウンロード処理]
    C --> D{ShowDialog結果}
    D -->|Cancel/その他| E[MsgInfo Download was canceled or failed.]
    D -->|OK| F{DownloadFile.FileExists?}
    F -->|Yes| G[Extract処理へ]
    F -->|No| H[MsgError Downloaded file is missing.]
    H --> I[ダイアログ表示]
    I --> J{ユーザー操作}
    J -->|OK| K[ダイアログクローズ]
    J -->|Copy Message| L[クリップボードコピー]
    L --> J
    K --> M[終了]
    E --> M
    G --> N[抽出処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし

### テーブル別参照項目詳細

該当なし

### 更新テーブル一覧

該当なし

#### 送信ログテーブル

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ファイル不在 | ダウンロード後にファイルが存在しない | MsgErrorで通知、ユーザーによる確認・再試行 |
| ディスク容量不足 | ディスクフルで書き込み失敗 | MsgErrorで通知、ディスク空き容量確認を促す |
| アンチウイルス削除 | セキュリティソフトによる削除 | MsgErrorで通知、除外設定を促す |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（自動リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- ファイル不在はセキュリティソフトによる削除の可能性も考慮すべき
- 信頼できるソースからのダウンロードであることを確認してから除外設定を行うべき

## 備考

- ToolUpdate.Download()内で使用される
- DialogResult.OKかつファイル不存在という矛盾した状態を検出するためのエラー
- MsgError形式でエラーとして報告（「Download was canceled or failed.」はMsgInfo）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ToolUpdateクラスのDownloadFileプロパティとFileExists拡張メソッドの関係を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ToolUpdate.vb | `Source/General/ToolUpdate.vb` | DownloadFileプロパティ（行10）、FileExists使用箇所 |

**読解のコツ**: DownloadFile.FileExistsはVB.NETの拡張メソッドで、File.Exists(DownloadFile)と等価。

#### Step 2: エントリーポイントを理解する

Download()メソッドの条件分岐を詳細に確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ToolUpdate.vb | `Source/General/ToolUpdate.vb` | Download関数の定義（行47-66）、特に行54-58の条件分岐 |

**主要処理フロー**:
1. **行53**: Using form As New DownloadForm(url, DownloadFile)
2. **行54**: If form.ShowDialog() = DialogResult.OK AndAlso DownloadFile.FileExists Then
3. **行55**: If DownloadFile.FileExists Then - 二重確認
4. **行56**: Extract() - 成功時は抽出へ
5. **行57**: Else - FileExistsがFalseの場合
6. **行58**: MsgError("Downloaded file is missing.")

#### Step 3: MsgError呼び出しを理解する

MsgErrorがどのようにエラーダイアログを表示するかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | General.vb | `Source/General/General.vb` | MsgError関数の定義（行1222-1240） |

**主要処理フロー**:
- **行1222-1240**: MsgError関数がTaskDialog(Of String)を生成
- TaskIcon.Error, ShowCopyButton = True でダイアログを表示

### プログラム呼び出し階層図

```
ToolUpdate.Update()  [ToolUpdate.vb:24]
    |
    +-- ToolUpdate.Download(url)  [ToolUpdate.vb:47]
           |
           +-- Using New DownloadForm(url, DownloadFile)
           |      |
           |      +-- form.ShowDialog()  [DownloadForm.vb]
           |             |
           |             +-- [ダウンロード処理]
           |
           +-- If DialogResult.OK AndAlso DownloadFile.FileExists Then
                  |
                  +-- If DownloadFile.FileExists Then  (二重確認)
                  |      |
                  |      +-- Extract()  [成功時]
                  |
                  +-- Else (ファイル不存在)
                         |
                         +-- MsgError("Downloaded file is missing.")
                                |
                                +-- MsgError()  [General.vb:1226]
                                       |
                                       +-- TaskDialog(Of String) 生成
                                       +-- Icon = TaskIcon.Error
                                       +-- ShowCopyButton = True
                                       +-- AddButton("OK")
                                       +-- Show()
```

### データフロー図

```
[入力]               [処理]                    [出力]

DownloadForm ──────> ShowDialog() ───────────> DialogResult
                           |
                     結果確認 ─────────────────> OK
                           |
               DownloadFile.FileExists ──────> 存在チェック
                           |
                     ┌─────┴─────┐
                     ↓           ↓
                   True       False
                     |           |
                Extract()   MsgError表示
                     |           |
                     |    "Downloaded file is
                     |        missing."
                     |           |
                     |     +-- Errorアイコン
                     |     +-- OKボタン
                     |     +-- Copy Messageボタン
                     |           |
                     +────> [後続処理/終了]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ToolUpdate.vb | `Source/General/ToolUpdate.vb` | ソース | Download関数、ファイル存在チェック、通知発生元 |
| DownloadForm.vb | `Source/Forms/DownloadForm.vb` | ソース | ダウンロード進捗表示フォーム |
| General.vb | `Source/General/General.vb` | ソース | MsgError関数の定義 |
| TaskDialog.vb | `Source/UI/TaskDialog.vb` | ソース | エラーダイアログの表示処理 |
| Extensions.vb | `Source/General/Extensions.vb` | ソース | FileExists拡張メソッドの定義（推定） |
